// SC300Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "SC300.h"
#include "SC300Dlg.h"
#include "SC5C0.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

// DEBUG PATCH PROGRAM
//
VOID SC_DEBUG( CHAR * fmt, ... )
{
	CHAR pszDebugDumpMessage[ MAX_PATH ] = "[SC3C0] [00000000] ";

	va_list marker;

	va_start( marker, fmt );

	StringCbPrintfA( pszDebugDumpMessage + 8, sizeof(pszDebugDumpMessage), "[%08X] ", 0x00000000 );

	StringCbVPrintfA( pszDebugDumpMessage + 8 + 10 + 1, sizeof(pszDebugDumpMessage), fmt, marker );

	va_end( marker );

	StringCbCatA( pszDebugDumpMessage, sizeof(pszDebugDumpMessage), "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

CRITICAL_SECTION g_h_video_info_access_critical_section[ 16 ];

ULONG            g_b_start_statsticis = FALSE;

ULONG			 g_n_start_recording[ 16 ];

ULONG            g_n_video_frame_number[ 16 ];

double           g_d_video_start_sample_time[ 16 ];

double           g_d_video_stop_sample_time[ 16 ];

ULONG            g_n_video_main_encoder_frame_number[ 16 ];

double           g_d_video_main_encoder_start_sample_time[ 16 ];

double           g_d_video_main_encoder_stop_sample_time[ 16 ];

double           g_d_video_main_encoder_sum_of_stream_size[ 16 ];

ULONG            g_n_video_sub_encoder_frame_number[ 16 ];

double           g_d_video_sub_encoder_start_sample_time[ 16 ];

double           g_d_video_sub_encoder_stop_sample_time[ 16 ];

double           g_d_video_sub_encoder_sum_of_stream_size[ 16 ];

ULONG            g_n_audio_sample_number[ 16 ];

double           g_d_audio_start_sample_time[ 16 ];

double           g_d_audio_stop_sample_time[ 16 ];

BOOL on_process_video_buffer( ULONG nChannelNumber, double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	ULONG		i = nChannelNumber - 1;

	CSC300Dlg *	pMainDialog = (CSC300Dlg *)(pUserData);

	// 5.0 YOU CAN ACCESS YUY2 VIDEO FRAME BUFFER FROM PBUFFER POINTER HERE.
	//
	{
		// ...
	}

	// DEBUG PATCH PROGRAM
	// 
	EnterCriticalSection( &g_h_video_info_access_critical_section[ i ] );

	if( g_b_start_statsticis ) {

		if( g_n_video_frame_number[ i ] == 0 ) {

			g_d_video_start_sample_time[ i ] = dSampleTime;
		}
		g_d_video_stop_sample_time[ i ] = dSampleTime;

		g_n_video_frame_number[ i ]++;
	}
	LeaveCriticalSection( &g_h_video_info_access_critical_section[ i ] );

	return FALSE;
}

BOOL on_process_video_main_encoder_buffer( ULONG nChannelNumber, double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	ULONG		i = nChannelNumber - 1;

	CSC300Dlg *	pMainDialog = (CSC300Dlg *)(pUserData);

	// 5.0 YOU CAN ACCESS H.264 BISTREAM BUFFER FROM PBUFFER POINTER HERE.
	//
	{	// ...
	
	//	SC_DEBUG( "CH%02d: %d, %d", i + 1, bIsKeyFrame, nBufferLen );

		EnterCriticalSection( &g_h_video_info_access_critical_section[ i ] );

		if( g_n_start_recording[ i ] == 0x00000001 ) {
		
			if( bIsKeyFrame ) {

				g_n_start_recording[ i ] = 0x00000002;
			}
		}
		if( g_n_start_recording[ i ] == 0x00000002 ) {

			pMainDialog->m_oRecordFiles[ i ].Write( pBuffer, nBufferLen );
		}
		LeaveCriticalSection( &g_h_video_info_access_critical_section[ i ] );
	}

	// DEBUG PATCH PROGRAM
	// 
	EnterCriticalSection( &g_h_video_info_access_critical_section[ i ] );

	if( g_b_start_statsticis ) {

		if( g_n_video_main_encoder_frame_number[ i ] == 0 ) {

			g_d_video_main_encoder_start_sample_time[ i ] = dSampleTime;
		}
		g_d_video_main_encoder_stop_sample_time[ i ] = dSampleTime;

		g_n_video_main_encoder_frame_number[ i ]++;

		g_d_video_main_encoder_sum_of_stream_size[ i ] += nBufferLen;
	}
	LeaveCriticalSection( &g_h_video_info_access_critical_section[ i ] );

	return FALSE;
}

BOOL on_process_video_sub_encoder_buffer( ULONG nChannelNumber, double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	ULONG		i = nChannelNumber - 1;

	CSC300Dlg *	pMainDialog = (CSC300Dlg *)(pUserData);

	// 5.0 YOU CAN ACCESS H.264 BISTREAM BUFFER FROM PBUFFER POINTER HERE.
	//
	{
		// ...
	}

	// DEBUG PATCH PROGRAM
	// 
	EnterCriticalSection( &g_h_video_info_access_critical_section[ i ] );

	if( g_b_start_statsticis ) {

		if( g_n_video_sub_encoder_frame_number[ i ] == 0 ) {

			g_d_video_sub_encoder_start_sample_time[ i ] = dSampleTime;
		}
		g_d_video_sub_encoder_stop_sample_time[ i ] = dSampleTime;

		g_n_video_sub_encoder_frame_number[ i ]++;

		g_d_video_sub_encoder_sum_of_stream_size[ i ] += nBufferLen;
	}
	LeaveCriticalSection( &g_h_video_info_access_critical_section[ i ] );

	return FALSE;
}

BOOL on_process_audio_buffer( ULONG nChannelNumber, double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	ULONG		i = nChannelNumber - 1;

	CSC300Dlg *	pMainDialog = (CSC300Dlg *)(pUserData);

	// 5.0 YOU CAN ACCESS PCM AUDIO DATA FROM PBUFFER POINTER NOW.
	{
		// ...
	}

	// DEBUG PATCH PROGRAM
	// 
	EnterCriticalSection( &g_h_video_info_access_critical_section[ i ] );

	if( g_b_start_statsticis ) {

		if( g_n_audio_sample_number[ i ] == 0 ) {

			g_d_audio_start_sample_time[ i ] = dSampleTime;
		}
		g_d_audio_stop_sample_time[ i ] = dSampleTime;

		g_n_audio_sample_number[ i ] += nBufferLen / 2; // MONO, 16BITS
	}
	LeaveCriticalSection( &g_h_video_info_access_critical_section[ i ] );

	return FALSE;
}

BOOL on_process_video_buffer_CH01( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_buffer( 0x00000001, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_buffer_CH02( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_buffer( 0x00000002, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_buffer_CH03( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_buffer( 0x00000003, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_buffer_CH04( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_buffer( 0x00000004, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_buffer_CH05( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_buffer( 0x00000005, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_buffer_CH06( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_buffer( 0x00000006, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_buffer_CH07( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_buffer( 0x00000007, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_buffer_CH08( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_buffer( 0x00000008, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_buffer_CH09( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_buffer( 0x00000009, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_buffer_CH10( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_buffer( 0x0000000A, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_buffer_CH11( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_buffer( 0x0000000B, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_buffer_CH12( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_buffer( 0x0000000C, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_buffer_CH13( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_buffer( 0x0000000D, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_buffer_CH14( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_buffer( 0x0000000E, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_buffer_CH15( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_buffer( 0x0000000F, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_buffer_CH16( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_buffer( 0x00000010, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_main_encoder_buffer_CH01( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_main_encoder_buffer( 0x00000001, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_main_encoder_buffer_CH02( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_main_encoder_buffer( 0x00000002, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_main_encoder_buffer_CH03( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_main_encoder_buffer( 0x00000003, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_main_encoder_buffer_CH04( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_main_encoder_buffer( 0x00000004, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_main_encoder_buffer_CH05( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_main_encoder_buffer( 0x00000005, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_main_encoder_buffer_CH06( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_main_encoder_buffer( 0x00000006, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_main_encoder_buffer_CH07( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_main_encoder_buffer( 0x00000007, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_main_encoder_buffer_CH08( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_main_encoder_buffer( 0x00000008, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_main_encoder_buffer_CH09( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_main_encoder_buffer( 0x00000009, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_main_encoder_buffer_CH10( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_main_encoder_buffer( 0x0000000A, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_main_encoder_buffer_CH11( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_main_encoder_buffer( 0x0000000B, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_main_encoder_buffer_CH12( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_main_encoder_buffer( 0x0000000C, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_main_encoder_buffer_CH13( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_main_encoder_buffer( 0x0000000D, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_main_encoder_buffer_CH14( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_main_encoder_buffer( 0x0000000E, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_main_encoder_buffer_CH15( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_main_encoder_buffer( 0x0000000F, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_main_encoder_buffer_CH16( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_main_encoder_buffer( 0x00000010, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_sub_encoder_buffer_CH01( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_sub_encoder_buffer( 0x00000001, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_sub_encoder_buffer_CH02( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_sub_encoder_buffer( 0x00000002, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_sub_encoder_buffer_CH03( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_sub_encoder_buffer( 0x00000003, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_sub_encoder_buffer_CH04( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_sub_encoder_buffer( 0x00000004, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_sub_encoder_buffer_CH05( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_sub_encoder_buffer( 0x00000005, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_sub_encoder_buffer_CH06( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_sub_encoder_buffer( 0x00000006, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_sub_encoder_buffer_CH07( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_sub_encoder_buffer( 0x00000007, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_sub_encoder_buffer_CH08( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_sub_encoder_buffer( 0x00000008, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_sub_encoder_buffer_CH09( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_sub_encoder_buffer( 0x00000009, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_sub_encoder_buffer_CH10( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_sub_encoder_buffer( 0x0000000A, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_sub_encoder_buffer_CH11( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_sub_encoder_buffer( 0x0000000B, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_sub_encoder_buffer_CH12( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_sub_encoder_buffer( 0x0000000C, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_sub_encoder_buffer_CH13( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_sub_encoder_buffer( 0x0000000D, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_sub_encoder_buffer_CH14( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_sub_encoder_buffer( 0x0000000E, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_sub_encoder_buffer_CH15( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_sub_encoder_buffer( 0x0000000F, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_sub_encoder_buffer_CH16( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_sub_encoder_buffer( 0x00000010, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_audio_buffer_CH01( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_audio_buffer( 0x00000001, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_audio_buffer_CH02( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_audio_buffer( 0x00000002, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_audio_buffer_CH03( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_audio_buffer( 0x00000003, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_audio_buffer_CH04( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_audio_buffer( 0x00000004, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_audio_buffer_CH05( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_audio_buffer( 0x00000005, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_audio_buffer_CH06( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_audio_buffer( 0x00000006, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_audio_buffer_CH07( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_audio_buffer( 0x00000007, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_audio_buffer_CH08( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_audio_buffer( 0x00000008, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_audio_buffer_CH09( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_audio_buffer( 0x00000009, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_audio_buffer_CH10( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_audio_buffer( 0x0000000A, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_audio_buffer_CH11( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_audio_buffer( 0x0000000B, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_audio_buffer_CH12( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_audio_buffer( 0x0000000C, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_audio_buffer_CH13( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_audio_buffer( 0x0000000D, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_audio_buffer_CH14( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_audio_buffer( 0x0000000E, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_audio_buffer_CH15( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_audio_buffer( 0x0000000F, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_audio_buffer_CH16( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_audio_buffer( 0x00000010, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSC300Dlg dialog

CSC300Dlg::CSC300Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSC300Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSC300Dlg)
	m_nPostAvgFrameRate = 0;
	m_nPostSkipFrameRate = 0;
	m_nRecordMode = 0;
	m_nRecordQuality = 0;
	m_nRecordBitrate = 0;
	m_nGop = 0;
	m_nProfile = 0;
	m_nEntropy = 0;
	m_nAspectRatioX = 0;
	m_nAspectRatioY = 0;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSC300Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSC300Dlg)
	DDX_Control(pDX, IDC_BUTTON_START_RECORD, m_btnStartRecord);
	DDX_Control(pDX, IDC_BUTTON_STOP_RECORD, m_btnStopRecord);
	DDX_Control(pDX, IDC_STATIC_DEBUG, m_staticDebugCtrl);
	DDX_Text(pDX, IDC_EDIT_POST_AVG_FRAMERATE, m_nPostAvgFrameRate);
	DDV_MinMaxUInt(pDX, m_nPostAvgFrameRate, 0, 120);
	DDX_Text(pDX, IDC_EDIT_POST_SKIP_FRAMERATE, m_nPostSkipFrameRate);
	DDV_MinMaxUInt(pDX, m_nPostSkipFrameRate, 0, 120);
	DDX_Text(pDX, IDC_EDIT_RECORD_MODE, m_nRecordMode);
	DDV_MinMaxUInt(pDX, m_nRecordMode, 0, 2);
	DDX_Text(pDX, IDC_EDIT_RECORD_QUALITY, m_nRecordQuality);
	DDV_MinMaxUInt(pDX, m_nRecordQuality, 0, 10000);
	DDX_Text(pDX, IDC_EDIT_RECORD_BITRATE, m_nRecordBitrate);
	DDV_MinMaxUInt(pDX, m_nRecordBitrate, 0, 100000000);
	DDX_Text(pDX, IDC_EDIT_GOP, m_nGop);
	DDV_MinMaxUInt(pDX, m_nGop, 1, 255);
	DDX_Text(pDX, IDC_EDIT_PROFILE, m_nProfile);
	DDV_MinMaxUInt(pDX, m_nProfile, 0, 3);
	DDX_Text(pDX, IDC_EDIT_ENTROPY, m_nEntropy);
	DDV_MinMaxUInt(pDX, m_nEntropy, 0, 2);
	DDX_Text(pDX, IDC_EDIT_ASPECT_RATIO_X, m_nAspectRatioX);
	DDV_MinMaxUInt(pDX, m_nAspectRatioX, 0, 4095);
	DDX_Text(pDX, IDC_EDIT_ASPECT_RATIO_Y, m_nAspectRatioY);
	DDV_MinMaxUInt(pDX, m_nAspectRatioY, 0, 4095);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSC300Dlg, CDialog)
	//{{AFX_MSG_MAP(CSC300Dlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BUTTON_POST_SKIP_FRAMERATE, OnButtonPostSkipFramerate)
	ON_BN_CLICKED(IDC_BUTTON_POST_AVG_FRAMERATE, OnButtonPostAvgFramerate)
	ON_BN_CLICKED(IDC_BUTTON_RECORD_MODE, OnButtonRecordMode)
	ON_BN_CLICKED(IDC_BUTTON_RECORD_QUALITY, OnButtonRecordQuality)
	ON_BN_CLICKED(IDC_BUTTON_RECORD_BITRATE, OnButtonRecordBitrate)
	ON_BN_CLICKED(IDC_BUTTON_FORCE_KEY_FRAME, OnButtonForceKeyFrame)
	ON_BN_CLICKED(IDC_BUTTON_START_RECORD, OnButtonStartRecord)
	ON_BN_CLICKED(IDC_BUTTON_STOP_RECORD, OnButtonStopRecord)
	ON_BN_CLICKED(IDC_BUTTON_GOP, OnButtonGop)
	ON_BN_CLICKED(IDC_BUTTON_PROFILE, OnButtonProfile)
	ON_BN_CLICKED(IDC_BUTTON_ENTROPY, OnButtonEntropy)
	ON_BN_CLICKED(IDC_BUTTON_ASPECT_RATIO, OnButtonAspectRatio)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSC300Dlg message handlers

BOOL CSC300Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
		
	m_nPostSkipFrameRate = 0;

	m_nPostAvgFrameRate = 0;

	m_nRecordMode = 1;
	
	m_nRecordQuality = 4000;

	m_nRecordBitrate = 4000000;

	m_nGop = 30;

	m_nProfile = 0;

	m_nEntropy = 0;

	m_nAspectRatioX = 0;

	m_nAspectRatioY = 0;

	UpdateData( FALSE );

	// 1.0 INITIALIZE COM DATABASE
	//
	HRESULT hr = CoInitialize( NULL );

	// 2.0 CREATE VIDEO DEVICES
	//
	PF_BUFFER_CALLBACK bcb_video[ 16 ] = { on_process_video_buffer_CH01, 

										   on_process_video_buffer_CH02, 
											
										   on_process_video_buffer_CH03, 
											
										   on_process_video_buffer_CH04, 
											
										   on_process_video_buffer_CH05, 
											
										   on_process_video_buffer_CH06, 
											
										   on_process_video_buffer_CH07, 
											
										   on_process_video_buffer_CH08,
										  
										   on_process_video_buffer_CH09, 

										   on_process_video_buffer_CH10, 
											
										   on_process_video_buffer_CH11, 
											
										   on_process_video_buffer_CH12, 
											
										   on_process_video_buffer_CH13, 
											
										   on_process_video_buffer_CH14, 
											
										   on_process_video_buffer_CH15, 
											
										   on_process_video_buffer_CH16 };

	PF_BUFFER_CALLBACK bcb_audio[ 16 ] = { on_process_audio_buffer_CH01, 
		
										   on_process_audio_buffer_CH02, 
											
										   on_process_audio_buffer_CH03, 
											
										   on_process_audio_buffer_CH04, 
											
										   on_process_audio_buffer_CH05, 
											
										   on_process_audio_buffer_CH06, 
											
										   on_process_audio_buffer_CH07, 
											
										   on_process_audio_buffer_CH08,
										  
										   on_process_audio_buffer_CH09, 
		
										   on_process_audio_buffer_CH10, 
											
										   on_process_audio_buffer_CH11, 
											
										   on_process_audio_buffer_CH12, 
											
										   on_process_audio_buffer_CH13, 
											
										   on_process_audio_buffer_CH14, 
											
										   on_process_audio_buffer_CH15, 
											
										   on_process_audio_buffer_CH16 };

	PF_BUFFER_CALLBACK bcb_video_main_encoder[ 16 ] = { on_process_video_main_encoder_buffer_CH01, 

													    on_process_video_main_encoder_buffer_CH02, 
														
													    on_process_video_main_encoder_buffer_CH03, 
														
													    on_process_video_main_encoder_buffer_CH04, 
														
													    on_process_video_main_encoder_buffer_CH05, 
														
													    on_process_video_main_encoder_buffer_CH06, 
														
													    on_process_video_main_encoder_buffer_CH07, 
														
													    on_process_video_main_encoder_buffer_CH08,
													   
													    on_process_video_main_encoder_buffer_CH09, 

													    on_process_video_main_encoder_buffer_CH10, 
														
													    on_process_video_main_encoder_buffer_CH11, 
														
													    on_process_video_main_encoder_buffer_CH12, 
														
													    on_process_video_main_encoder_buffer_CH13, 
														
													    on_process_video_main_encoder_buffer_CH14, 
														
													    on_process_video_main_encoder_buffer_CH15, 
														
													    on_process_video_main_encoder_buffer_CH16 };

	PF_BUFFER_CALLBACK bcb_video_sub_encoder[ 16 ] = { on_process_video_sub_encoder_buffer_CH01, 

													   on_process_video_sub_encoder_buffer_CH02, 
														
													   on_process_video_sub_encoder_buffer_CH03, 
														
													   on_process_video_sub_encoder_buffer_CH04, 
														
													   on_process_video_sub_encoder_buffer_CH05, 
														
													   on_process_video_sub_encoder_buffer_CH06, 
														
													   on_process_video_sub_encoder_buffer_CH07, 
														
													   on_process_video_sub_encoder_buffer_CH08,
													   
													   on_process_video_sub_encoder_buffer_CH09, 

													   on_process_video_sub_encoder_buffer_CH10, 
														
													   on_process_video_sub_encoder_buffer_CH11, 
														
													   on_process_video_sub_encoder_buffer_CH12, 
														
													   on_process_video_sub_encoder_buffer_CH13, 
														
													   on_process_video_sub_encoder_buffer_CH14, 
														
													   on_process_video_sub_encoder_buffer_CH15, 
														
													   on_process_video_sub_encoder_buffer_CH16 };

	PVOID params[ 16 ] = { this, this, this, this, this, this, this, this, this, this, this, this, this, this, this, this };

	for( ULONG i = 0 ; i < 16 ; i++ ) {

		if( m_oAnalogDeviceVideoGraphs[ i ].Create( L"MZ0380 PCI", i, bcb_video[ i ], params[ i ] ) == FALSE ) {

			m_oAnalogDeviceVideoGraphs[ i ].Close();
		}
		if( m_oAnalogDeviceVideoMainEncoderGraphs[ i ].Create( L"MZ0380 PCI", i, bcb_video_main_encoder[ i ], params[ i ] ) == FALSE ) {

			m_oAnalogDeviceVideoMainEncoderGraphs[ i ].Close();
		}
//		if( m_oAnalogDeviceVideoSubEncoderGraphs[ i ].Create( L"MZ0380 PCI", i, bcb_video_sub_encoder[ i ], params[ i ] ) == FALSE ) {
//
//			m_oAnalogDeviceVideoSubEncoderGraphs[ i ].Close();
//		}
		m_oAnalogDeviceVideoGraphs[ i ].SetStandard( KS_AnalogVideo_NTSC_M );

		m_oAnalogDeviceVideoGraphs[ i ].SetFormat( MAKEFOURCC('Y', 'V', '1', '2'), 960, 480, 12, 29.970 ); // SD

		m_oAnalogDeviceVideoMainEncoderGraphs[ i ].SetFormat( MAKEFOURCC('H', '2', '6', '4'), 960 / 1, 480 / 1, 24, 29.970 ); // SD

		m_oAnalogDeviceVideoMainEncoderGraphs[ i ].SetCustomProperty( KSPROPERTY_CUSTOM_XET_ENCODER_VIDEO_BIT_RATE_MODE, m_nRecordMode );

		m_oAnalogDeviceVideoMainEncoderGraphs[ i ].SetCustomProperty( KSPROPERTY_CUSTOM_XET_ENCODER_VIDEO_BIT_RATE, m_nRecordBitrate );

		m_oAnalogDeviceVideoMainEncoderGraphs[ i ].SetCustomProperty( KSPROPERTY_CUSTOM_XET_ENCODER_VIDEO_QUALITY, m_nRecordQuality );

		m_oAnalogDeviceVideoMainEncoderGraphs[ i ].SetCustomProperty( KSPROPERTY_CUSTOM_XET_ENCODER_VIDEO_GOP, m_nGop );

		m_oAnalogDeviceVideoMainEncoderGraphs[ i ].SetCustomProperty( KSPROPERTY_CUSTOM_XET_ENCODER_VIDEO_PROFILE, m_nProfile );

		m_oAnalogDeviceVideoMainEncoderGraphs[ i ].SetCustomProperty( KSPROPERTY_CUSTOM_XET_ENCODER_VIDEO_ENTROPY, m_nEntropy );

		m_oAnalogDeviceVideoMainEncoderGraphs[ i ].SetCustomProperty( KSPROPERTY_CUSTOM_XET_ENCODER_VIDEO_ASPECT_RATIO, (m_nAspectRatioX << 12) + (m_nAspectRatioY << 0) );

//		m_oAnalogDeviceVideoSubEncoderGraphs[ i ].SetFormat( MAKEFOURCC('X', '2', '6', '4'), 960 / 2, 480 / 2, 24, 29.970 ); // SD / 4
//
//		m_oAnalogDeviceVideoSubEncoderGraphs[ i ].SetCustomProperty( KSPROPERTY_CUSTOM_XET_ENCODER_VIDEO_BIT_RATE_MODE, m_nRecordMode );
//
//		m_oAnalogDeviceVideoSubEncoderGraphs[ i ].SetCustomProperty( KSPROPERTY_CUSTOM_XET_ENCODER_VIDEO_BIT_RATE, m_nRecordBitrate / 4 );
//
//		m_oAnalogDeviceVideoSubEncoderGraphs[ i ].SetCustomProperty( KSPROPERTY_CUSTOM_XET_ENCODER_VIDEO_QUALITY, m_nRecordQuality );
//
//		m_oAnalogDeviceVideoSubEncoderGraphs[ i ].SetCustomProperty( KSPROPERTY_CUSTOM_XET_ENCODER_VIDEO_GOP, m_nGop );
//
//		m_oAnalogDeviceVideoSubEncoderGraphs[ i ].SetCustomProperty( KSPROPERTY_CUSTOM_XET_ENCODER_VIDEO_PROFILE, m_nProfile );
//
//		m_oAnalogDeviceVideoSubEncoderGraphs[ i ].SetCustomProperty( KSPROPERTY_CUSTOM_XET_ENCODER_VIDEO_ENTROPY, m_nEntropy );
//
//		m_oAnalogDeviceVideoSubEncoderGraphs[ i ].SetCustomProperty( KSPROPERTY_CUSTOM_XET_ENCODER_VIDEO_ASPECT_RATIO, (m_nAspectRatioX << 12) + (m_nAspectRatioY << 0) );
	}

	// 3.0 CREATE ADUIO DEVICES
	//
	for( i = 0 ; i < 16 ; i++ ) {

		if( m_oAnalogDeviceAudioGraphs[ i ].Create( L"MZ0380 PCI, Analog WaveIn", i, bcb_audio[ i ], params[ i ] ) == FALSE ) {

			m_oAnalogDeviceAudioGraphs[ i ].Close();
		}
		m_oAnalogDeviceAudioGraphs[ i ].SetFormat( 1, 16, 48000 ); // IT IS ALWAYS MONO/16BIS/48000HZ
	}

	// DEBUG PATCH PROGRAM
	// 
	for( i = 0 ; i < 16 ; i++ ) {

		InitializeCriticalSection( &g_h_video_info_access_critical_section[ i ] );

		g_n_video_frame_number[ i ] = 0;

		g_d_video_start_sample_time[ i ] = 0;

		g_d_video_stop_sample_time[ i ] = 0;

		g_n_video_main_encoder_frame_number[ i ] = 0;

		g_d_video_main_encoder_start_sample_time[ i ] = 0;

		g_d_video_main_encoder_stop_sample_time[ i ] = 0;

		g_d_video_main_encoder_sum_of_stream_size[ i ] = 0;

		g_n_video_sub_encoder_frame_number[ i ] = 0;

		g_d_video_sub_encoder_start_sample_time[ i ] = 0;

		g_d_video_sub_encoder_stop_sample_time[ i ] = 0;

		g_d_video_sub_encoder_sum_of_stream_size[ i ] = 0;

		g_n_audio_sample_number[ i ] = 0;

		g_d_audio_start_sample_time[ i ] = 0;

		g_d_audio_stop_sample_time[ i ] = 0;

		g_n_start_recording[ i ] = 0x00000000;

		g_b_start_statsticis = FALSE;
	}

	// 4.0 RUN VIDEO & AUDIO DEVICES
	//
	for( i = 0 ; i < 16 ; i++ ) { m_oAnalogDeviceVideoGraphs[ i ].Run(); }

	for( i = 0 ; i < 16 ; i++ ) { m_oAnalogDeviceVideoMainEncoderGraphs[ i ].Run(); }

	for( i = 0 ; i < 16 ; i++ ) { m_oAnalogDeviceVideoSubEncoderGraphs[ i ].Run(); }

	for( i = 0 ; i < 16 ; i++ ) { m_oAnalogDeviceAudioGraphs[ i ].Run(); }

	// DEBUG PATCH PROGRAM
	// 
	{	SetTimer( 0x00000000, 3000, NULL );

		SetTimer( 0x00000001, 1000, NULL );
	}
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSC300Dlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here

	ULONG i = 0;

	KillTimer( 0x00000000 );

	KillTimer( 0x00000001 );

	// 6.0 STOP & CLOSE DEVICES
	//
	for( i = 0 ; i < 16 ; i++ ) { m_oAnalogDeviceAudioGraphs[ i ].Stop(); }

	for( i = 0 ; i < 16 ; i++ ) { m_oAnalogDeviceVideoSubEncoderGraphs[ i ].Stop(); }

	for( i = 0 ; i < 16 ; i++ ) { m_oAnalogDeviceVideoMainEncoderGraphs[ i ].Stop(); }

	for( i = 0 ; i < 16 ; i++ ) { m_oAnalogDeviceVideoGraphs[ i ].Stop(); }

	for( i = 0 ; i < 16 ; i++ ) { m_oAnalogDeviceVideoGraphs[ i ].Stop(); }

	for( i = 0 ; i < 16 ; i++ ) { m_oAnalogDeviceAudioGraphs[ i ].Close(); }

	for( i = 0 ; i < 16 ; i++ ) { m_oAnalogDeviceVideoSubEncoderGraphs[ i ].Close(); }

	for( i = 0 ; i < 16 ; i++ ) { m_oAnalogDeviceVideoMainEncoderGraphs[ i ].Close(); }

	for( i = 0 ; i < 16 ; i++ ) { m_oAnalogDeviceVideoGraphs[ i ].Close(); }

	for( i = 0 ; i < 16 ; i++ ) { DeleteCriticalSection( &g_h_video_info_access_critical_section[ i ] ); }

	// 7.0 CLOSE COM DATABASE
	//
	CoUninitialize();
}

void CSC300Dlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSC300Dlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSC300Dlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CSC300Dlg::OnOK() 
{
	// TODO: Add extra validation here
	
//	CDialog::OnOK();
}

void CSC300Dlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

void CSC300Dlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	
	if( nIDEvent == 0x00000000 ) {

		KillTimer( 0x00000000 );

		g_b_start_statsticis = TRUE;
	}
	if( nIDEvent == 0x00000001 ) {

		CHAR psz[ MAX_PATH * 16 ] = "";

		// DUMP INPUT RESOLUTION
		//
		for( ULONG i = 0 ; i < 16 ; i++ ) {

			EnterCriticalSection( &g_h_video_info_access_critical_section[ i ] );

			ULONG resolution = 0x00000000;
				
			m_oAnalogDeviceVideoGraphs[ i ].GetCustomProperty( 210, &resolution );

			StringCbPrintfA( psz + strlen(psz), MAX_PATH * 2, "CH%02d:%08X, ", i + 1, resolution );

			if( i % 16 == 15 ) { StringCbPrintfA( psz + strlen(psz), MAX_PATH * 2, "( RESOLUTION )\n" ); }

			LeaveCriticalSection( &g_h_video_info_access_critical_section[ i ] );
		}

		// DUMP VIDEO FRAMERATE
		//
		for( i = 0 ; i < 16 ; i++ ) {

			EnterCriticalSection( &g_h_video_info_access_critical_section[ i ] );

			if( g_d_video_stop_sample_time[ i ] > g_d_video_start_sample_time[ i ] ) {

				StringCbPrintfA( psz + strlen(psz), MAX_PATH * 2, "CH%02d:%8d, ", i + 1, (UINT)(((g_n_video_frame_number[ i ] - 1) * 1000000.0) / (g_d_video_stop_sample_time[ i ] - g_d_video_start_sample_time[ i ])) );
			}
			else {

				StringCbPrintfA( psz + strlen(psz), MAX_PATH * 2, "CH%02d:%8d, ", i + 1, 0 );
			}
			if( i % 16 == 15 ) { StringCbPrintfA( psz + strlen(psz), MAX_PATH * 2, "( VIDEO PREVIEW FPS * 1000000 )\n" ); }

			LeaveCriticalSection( &g_h_video_info_access_critical_section[ i ] );
		}

		// DUMP VIDEO MAIN ENCODER FRAMERATE
		//
		for( i = 0 ; i < 16 ; i++ ) {

			EnterCriticalSection( &g_h_video_info_access_critical_section[ i ] );

			if( g_d_video_main_encoder_stop_sample_time[ i ] > g_d_video_main_encoder_start_sample_time[ i ] ) {

				StringCbPrintfA( psz + strlen(psz), MAX_PATH * 2, "CH%02d:%8d, ", i + 1, (UINT)(((g_n_video_main_encoder_frame_number[ i ] - 1) * 1000000.0) / (g_d_video_main_encoder_stop_sample_time[ i ] - g_d_video_main_encoder_start_sample_time[ i ])) );
			}
			else {

				StringCbPrintfA( psz + strlen(psz), MAX_PATH * 2, "CH%02d:%8d, ", i + 1, 0 );
			}
			if( i % 16 == 15 ) { StringCbPrintfA( psz + strlen(psz), MAX_PATH * 2, "( VIDEO M.H264 FPS * 1000000 )\n" ); }

			LeaveCriticalSection( &g_h_video_info_access_critical_section[ i ] );
		}

		// DUMP VIDEO MAIN ENCODER BPS
		//
		for( i = 0 ; i < 16 ; i++ ) {

			EnterCriticalSection( &g_h_video_info_access_critical_section[ i ] );

			if( g_d_video_main_encoder_stop_sample_time[ i ] > g_d_video_main_encoder_start_sample_time[ i ] ) {

				StringCbPrintfA( psz + strlen(psz), MAX_PATH * 2, "CH%02d:%8d, ", i + 1, (UINT)((g_d_video_main_encoder_sum_of_stream_size[ i ] * 8) / (g_d_video_main_encoder_stop_sample_time[ i ] - g_d_video_main_encoder_start_sample_time[ i ])) );
			}
			else {

				StringCbPrintfA( psz + strlen(psz), MAX_PATH * 2, "CH%02d:%8d, ", i + 1, 0 );
			}
			if( i % 16 == 15 ) { StringCbPrintfA( psz + strlen(psz), MAX_PATH * 2, "( VIDEO M.H264 BPS )\n" ); }

			LeaveCriticalSection( &g_h_video_info_access_critical_section[ i ] );
		}

		// DUMP VIDEO SUB ENCODER FRAMERATE
		//
		for( i = 0 ; i < 16 ; i++ ) {

			EnterCriticalSection( &g_h_video_info_access_critical_section[ i ] );

			if( g_d_video_sub_encoder_stop_sample_time[ i ] > g_d_video_sub_encoder_start_sample_time[ i ] ) {

				StringCbPrintfA( psz + strlen(psz), MAX_PATH * 2, "CH%02d:%8d, ", i + 1, (UINT)(((g_n_video_sub_encoder_frame_number[ i ] - 1) * 1000000.0) / (g_d_video_sub_encoder_stop_sample_time[ i ] - g_d_video_sub_encoder_start_sample_time[ i ])) );
			}
			else {

				StringCbPrintfA( psz + strlen(psz), MAX_PATH * 2, "CH%02d:%8d, ", i + 1, 0 );
			}
			if( i % 16 == 15 ) { StringCbPrintfA( psz + strlen(psz), MAX_PATH * 2, "( VIDEO S.H264 FPS * 1000000 )\n" ); }

			LeaveCriticalSection( &g_h_video_info_access_critical_section[ i ] );
		}

		// DUMP VIDEO SUB ENCODER BPS
		//
		for( i = 0 ; i < 16 ; i++ ) {

			EnterCriticalSection( &g_h_video_info_access_critical_section[ i ] );

			if( g_d_video_sub_encoder_stop_sample_time[ i ] > g_d_video_sub_encoder_start_sample_time[ i ] ) {

				StringCbPrintfA( psz + strlen(psz), MAX_PATH * 2, "CH%02d:%8d, ", i + 1, (UINT)((g_d_video_main_encoder_sum_of_stream_size[ i ] * 8) / (g_d_video_sub_encoder_stop_sample_time[ i ] - g_d_video_sub_encoder_start_sample_time[ i ])) );
			}
			else {

				StringCbPrintfA( psz + strlen(psz), MAX_PATH * 2, "CH%02d:%8d, ", i + 1, 0 );
			}
			if( i % 16 == 15 ) { StringCbPrintfA( psz + strlen(psz), MAX_PATH * 2, "( VIDEO S.H264 BPS )\n" ); }

			LeaveCriticalSection( &g_h_video_info_access_critical_section[ i ] );
		}

		// DUMP ADUIO SAMPLE RATE
		//
		for( i = 0 ; i < 16 ; i++ ) {

			EnterCriticalSection( &g_h_video_info_access_critical_section[ i ] );

			if( g_d_audio_stop_sample_time[ i ] > g_d_audio_start_sample_time[ i ] ) {

				StringCbPrintfA( psz + strlen(psz), MAX_PATH * 2, "CH%02d:%8d, ", i + 1, (UINT)((((double)(g_n_audio_sample_number[ i ] - 1)) * 1000) / (g_d_audio_stop_sample_time[ i ] - g_d_audio_start_sample_time[ i ])) );
			}
			else {

				StringCbPrintfA( psz + strlen(psz), MAX_PATH * 2, "CH%02d:%8d, ", i + 1, 0 );
			}
			if( i % 16 == 15 ) { StringCbPrintfA( psz + strlen(psz), MAX_PATH * 2, "( AUDIO SPS * 1000 )\n" ); }

			LeaveCriticalSection( &g_h_video_info_access_critical_section[ i ] );
		}
		m_staticDebugCtrl.SetWindowText( psz );
	}
	CDialog::OnTimer(nIDEvent);
}

void CSC300Dlg::ClearStatsticisInfo()
{
	for( ULONG i = 0 ; i < 16 ; i++ ) {

		EnterCriticalSection( &g_h_video_info_access_critical_section[ i ] );

//		g_n_video_frame_number[ i ] = 0;
//
//		g_d_video_start_sample_time[ i ] = 0;
//
//		g_d_video_stop_sample_time[ i ] = 0;

		g_n_video_main_encoder_frame_number[ i ] = 0;

		g_d_video_main_encoder_start_sample_time[ i ] = 0;

		g_d_video_main_encoder_stop_sample_time[ i ] = 0;

		g_d_video_main_encoder_sum_of_stream_size[ i ] = 0;

		g_n_video_sub_encoder_frame_number[ i ] = 0;

		g_d_video_sub_encoder_start_sample_time[ i ] = 0;

		g_d_video_sub_encoder_stop_sample_time[ i ] = 0;

		g_d_video_sub_encoder_sum_of_stream_size[ i ] = 0;

//		g_n_audio_sample_number[ i ] = 0;
//
//		g_d_audio_start_sample_time[ i ] = 0;
//
//		g_d_audio_stop_sample_time[ i ] = 0;

		LeaveCriticalSection( &g_h_video_info_access_critical_section[ i ] );
	}
}

void CSC300Dlg::OnButtonPostSkipFramerate() 
{
	// TODO: Add your control notification handler code here
	
	UpdateData( TRUE );

	for( ULONG i = 0 ; i < 16 ; i++ ) {
	
		m_oAnalogDeviceVideoMainEncoderGraphs[ i ].SetCustomProperty( KSPROPERTY_CUSTOM_XET_ENCODER_VIDEO_SKIP_FRAME_RATE, m_nPostSkipFrameRate ); // POST.SKIP.FRAMERATE
	}
	ClearStatsticisInfo();
}

void CSC300Dlg::OnButtonPostAvgFramerate() 
{
	// TODO: Add your control notification handler code here
	
	UpdateData( TRUE );

	for( ULONG i = 0 ; i < 16 ; i++ ) {

		m_oAnalogDeviceVideoMainEncoderGraphs[ i ].SetCustomProperty( KSPROPERTY_CUSTOM_XET_ENCODER_VIDEO_AVG_FRAME_RATE, m_nPostAvgFrameRate ); // POST.AVG.FRAMERATE
	}
	ClearStatsticisInfo();
}

void CSC300Dlg::OnButtonRecordMode() 
{
	// TODO: Add your control notification handler code here
	
	UpdateData( TRUE );

	for( ULONG i = 0 ; i < 16 ; i++ ) {

		if( m_nRecordMode == 0 ) {

			m_oAnalogDeviceVideoMainEncoderGraphs[ i ].SetCustomProperty( KSPROPERTY_CUSTOM_XET_ENCODER_VIDEO_BIT_RATE_MODE, m_nRecordMode ); // RECORD.MODE

			m_oAnalogDeviceVideoMainEncoderGraphs[ i ].SetCustomProperty( KSPROPERTY_CUSTOM_XET_ENCODER_VIDEO_QUALITY, m_nRecordQuality ); // RECORD.QUALITY
		}
		else {

			m_oAnalogDeviceVideoMainEncoderGraphs[ i ].SetCustomProperty( KSPROPERTY_CUSTOM_XET_ENCODER_VIDEO_BIT_RATE_MODE, m_nRecordMode ); // RECORD.MODE

			m_oAnalogDeviceVideoMainEncoderGraphs[ i ].SetCustomProperty( KSPROPERTY_CUSTOM_XET_ENCODER_VIDEO_BIT_RATE, m_nRecordBitrate ); // RECORD.BIT.RATE
		}
	}
	ClearStatsticisInfo();
}

void CSC300Dlg::OnButtonRecordQuality() 
{
	// TODO: Add your control notification handler code here
	
	UpdateData( TRUE );

	for( ULONG i = 0 ; i < 16 ; i++ ) {

		m_oAnalogDeviceVideoMainEncoderGraphs[ i ].SetCustomProperty( KSPROPERTY_CUSTOM_XET_ENCODER_VIDEO_QUALITY, m_nRecordQuality ); // RECORD.QUALITY
	}
	ClearStatsticisInfo();	
}

void CSC300Dlg::OnButtonRecordBitrate() 
{
	// TODO: Add your control notification handler code here
		
	UpdateData( TRUE );

	for( ULONG i = 0 ; i < 16 ; i++ ) {

		m_oAnalogDeviceVideoMainEncoderGraphs[ i ].SetCustomProperty( KSPROPERTY_CUSTOM_XET_ENCODER_VIDEO_BIT_RATE, m_nRecordBitrate ); // RECORD.BIT.RATE
	}
	ClearStatsticisInfo();
}

void CSC300Dlg::OnButtonForceKeyFrame() 
{
	// TODO: Add your control notification handler code here
			
	UpdateData( TRUE );

	for( ULONG i = 0 ; i < 16 ; i++ ) {

		m_oAnalogDeviceVideoMainEncoderGraphs[ i ].SetCustomProperty( KSPROPERTY_CUSTOM_SET_ENCODER_VIDEO_KEY_FRAME, 1 ); // FORCE.KEY.FRAME
	}
	ClearStatsticisInfo();
}

void CSC300Dlg::OnButtonGop() 
{
	// TODO: Add your control notification handler code here
	
	UpdateData( TRUE );

	for( ULONG i = 0 ; i < 16 ; i++ ) {
	
		m_oAnalogDeviceVideoMainEncoderGraphs[ i ].SetCustomProperty( KSPROPERTY_CUSTOM_XET_ENCODER_VIDEO_GOP, m_nGop ); // GOP
	}
	ClearStatsticisInfo();	
}

void CSC300Dlg::OnButtonProfile() 
{
	// TODO: Add your control notification handler code here
	
	UpdateData( TRUE );

	for( ULONG i = 0 ; i < 16 ; i++ ) {
	
		m_oAnalogDeviceVideoMainEncoderGraphs[ i ].SetCustomProperty( KSPROPERTY_CUSTOM_XET_ENCODER_VIDEO_PROFILE, m_nProfile ); // PROFILE
	}
	ClearStatsticisInfo();		
}

void CSC300Dlg::OnButtonEntropy() 
{
	// TODO: Add your control notification handler code here
		
	UpdateData( TRUE );

	for( ULONG i = 0 ; i < 16 ; i++ ) {
	
		m_oAnalogDeviceVideoMainEncoderGraphs[ i ].SetCustomProperty( KSPROPERTY_CUSTOM_XET_ENCODER_VIDEO_ENTROPY, m_nEntropy ); // ENTROPY
	}
	ClearStatsticisInfo();	
}


void CSC300Dlg::OnButtonAspectRatio() 
{
	// TODO: Add your control notification handler code here
			
	UpdateData( TRUE );

	for( ULONG i = 0 ; i < 16 ; i++ ) {

		m_oAnalogDeviceVideoMainEncoderGraphs[ i ].SetCustomProperty( KSPROPERTY_CUSTOM_XET_ENCODER_VIDEO_ASPECT_RATIO, (m_nAspectRatioX << 12) + (m_nAspectRatioY << 0) ); // ASPECT RATIO
	}
	ClearStatsticisInfo();
}

void CSC300Dlg::OnButtonStartRecord() 
{
	// TODO: Add your control notification handler code here

	m_btnStartRecord.EnableWindow( FALSE );

	m_btnStopRecord.EnableWindow( TRUE );

	for( ULONG i = 0 ; i < 16 ; i++ ) {

		CString strFileName;

		strFileName.Format( "CH%02d.H264", i + 1 );

		m_oRecordFiles[ i ].Open( strFileName, CFile::modeCreate | CFile::modeWrite );
	}
	for( i = 0 ; i < 16 ; i++ ) {

		EnterCriticalSection( &g_h_video_info_access_critical_section[ i ] );

		g_n_start_recording[ i ] = 0x00000001;

		LeaveCriticalSection( &g_h_video_info_access_critical_section[ i ] );
	}
}

void CSC300Dlg::OnButtonStopRecord() 
{
	// TODO: Add your control notification handler code here

	m_btnStartRecord.EnableWindow( TRUE );

	m_btnStopRecord.EnableWindow( FALSE );

	for( ULONG i = 0 ; i < 16 ; i++ ) {

		EnterCriticalSection( &g_h_video_info_access_critical_section[ i ] );

		g_n_start_recording[ i ] = 0x00000000;

		LeaveCriticalSection( &g_h_video_info_access_critical_section[ i ] );
	}
	for( i = 0 ; i < 16 ; i++ ) {

		m_oRecordFiles[ i ].Close();
	}
}